#pragma rtGlobals=1		// Use modern global access method.
#include <Strings as Lists>


menu "Data"
	"-"

	Submenu "USANS"
		"Open USANS"
		"Scan Header"
		"Transmission Correction USANS.../4."
		"Analyze USANS"
		"Modify Wave"
		"Make Poly wave"
	end
	
	"Open Kaleidagraph"
end

//Macro SaveForTomLakeDesmear(qwave,savename)
	string/g gqwave,gsavename
	string qwave=gqwave,savename=gsavename
	prompt qwave,"Enter the qwave to save for desmear:",popup,WaveList("Q*", ";", "WIN:"+WinName(0, 1))
	prompt savename,"Enter the filename for the desmear file:"
	
	silent 1
	RemoveAllNegativesInQRSPlot()
	gsavename=savename;gqwave=qwave
	string thetaname="t2"+qwave[1,32],rwave="R"+qwave[1,32],swave="S"+qwave[1,32]
	print thetaname
	duplicate $qwave $thetaname
	$thetaname=2*asin($qwave*1.54/(4*Pi))*180/Pi
	Save/J/I/W $thetaname,$qwave,$rwave,$swave as savename
	killwaves  $thetaname
Endmacro

Macro MakePolyWave(qwave)
	String qwave
	Prompt qWave,"Pick Input Qwave:",popup,WaveList("q*", ";", "WIN:"+WinName(0, 1))
	
	//returns the value of a polymnomial evaluated at qvalues of wave.
	Silent 1
	string rwave=("rfit"+qwave[1,100]),qout=("qfit"+qwave[1,100])
	duplicate/O $qwave,$rwave,$qout
	variable n=0
	do
		$rwave(n)=poly(W_coef,(log($qwave(n))))
		n=n+1
	while (n<=(numpnts($rwave)))
	$rwave=10^$rwave
	
Macro ModifyWaveLog(rwave)
	String rWave
	Prompt rWave,"Pick Target:",popup,WaveList("R*", ";", "WIN:"+WinName(0, 1))
	//can be set up to do various things to a wave like take log.
	//Silent 1;PAUSEUPDATE
	String/g rWavename=rwave
	Variable/g Multiplier=1
	String/g rCorWavename,sCorWavename,qCorWavename,rwavename,qwavename,swavename
	qwavename="q"+rwavename[1,35]
	swavename="s"+rwavename[1,35]
	rCorWavename=rwavename+".102"//NORMALLY[0,6]  adds extension to indicate modification
	sCorWavename=swavename+".102" //Normally .101
	qCorWavename=qwavename+".102"
	Duplicate/O $qwavename,$qCorWavename, $rCorWavename, $sCorWavename
	$rCorWavename=LOG($rWavename)
	$qCorWavename=LOG($qWavename)
	$sCorWavename=LOG($sWavename)
endMacro



Macro ScanHeader ()
	string wavelst,targetwave,targetnote, notelist
	make/T/O Header
	Variable n=0
	wavelst=WaveList("r*", ";", "")
	
	//Forms a wave from all the header lines in the folder and displays as a table
	Silent 1
	edit header//Displays table
	do 
		targetwave=getstrfromlist(wavelst,n,";")
		targetnote =note($targetwave)
		notelist=targetwave
		Header[(n)]=notelist
		notelist=getstrfromlist(targetnote,3,"\r")
		Header[(n)]=Header[(n)][0]+notelist[5,100]
		n=n+1
	while (n<=100)
end
	
Macro TransmissionCorrectionUSANS(Run, QBkg,MTrun,FltBkg,Trans)
	String/g gRun,gMTRun
	String Run=grun, MTRun=gMTrun
	Variable/g gTrans,gFltBkg,gQbkg
	Variable FltBkg=gFltBkg, QBkg=gQBkg,Trans=gTrans
	Prompt Run,"Choose Run:",popup,WaveList("R*", ";", "WIN:"+WinName(0, 1))
	Prompt QBkg,"Do you want to subtract the Bkg Wave?",popup,"Yes;No"
	Prompt MTrun,"Choose MT Background for above",popup,WaveList("R*", ";", "WIN:"+WinName(0, 1))
	Prompt FltBkg,"Enter Flat Background to be subtracted"
	Prompt Trans "Enter transmission or zero for calculation"
	
	Silent 1;pauseupdate
	String mwavename,rwavename,qwavename,swavename
	String mMTwavename,rMTwavename,sMTwavename,qMTwavename
	String rCorWavename,sCorWavename,qCorWavename
	variable npts,RUNmon,MTmon
	Run=Run[1,100]
	MTrun=MTrun[1,100]
	mwavename= "m"+run;rwavename= "r"+run;swavename= "s"+run;qwavename="q"+run
	mMTwavename="m"+MTrun;rMTwavename ="r"+MTrun;sMTwavename ="s"+MTrun
	qMTwavename="q"+MTrun
	rCorWavename=rwavename[0,6]+"100"
	sCorWavename=swavename[0,6]+"100"
	qCorWavename=qwavename[0,6]+"100"
	If (Trans==0)
		npts=numpnts($mwavename)
		RUNmon =$mwavename[npts-1]
		npts=numpnts($mMTwavename)
		MTmon= $mMTwavename[npts-1]
		Trans =RUNmon/MTmon //calculates transmission from the monitor counts when off zero angle
	endif
	Duplicate/O $qwavename,$qCorWavename, $rCorWavename, $sCorWavename
	$rCorWavename=(($rwavename)/Trans)-FltBkg
	$sCorWavename=$sWavename/trans
	AppendToGraph $rCorWavename vs $qCorwavename
	String TheNote
	TheNote= note($rwavename)+"Transmission = "+num2str(Trans)
	TheNote+="\r"+ rCorWavename +" = (" + rWavename +"/" +num2str(Trans)+")"	

	if (Qbkg==1)
		$rCorWavename=$rCorwavename-($rMTwavename)
		$sCorWavename=(($swavename)+($sMTwavename))
		TheNote+=" - "+rMTwavename
	endif
	TheNote+=" - "+num2str(FltBkg)
	Print "Transmission ="+num2str(Trans)
	Note $rCorWavename TheNote
	
	ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3
	ErrorBars $rCorwavename, Y,wave=($sCorWavename,$sCorWavename)
	RemoveAllNegativesInQRSPlot()
	//AppendToGraph $rMTwavename vs $qMTwavename
	//SetAxis bottom 2e-05,0.0002
	//ModifyGraph mode=3
	ShowInfo;ShowTools/A
	gRun=Run;gMTRun=MTrun;gTrans=Trans;gFltBkg=FltBkg;gQbkg=Qbkg
end


Macro OpenKaleidagraph()

	//DoAlert 0,"Data must be in tab-delimited format \r Close all tables and plots to reload \rChange file type to TEXT"
	variable refno=2
	Silent 1
	Open /D/R refNo             //open dialog and load s_filename, but not open file
		getfilename(s_filename)
		
	LoadWave/J/W/D/N/O/E=1/K=0/V={"\t"," $",0,0}/L={0,1,0,1,0}  s_filename

	//string, bwave ="bkg"+gfilename ,rwave ="r"+gfilename ,owave= "offset"+gfilename,qwave="q"+gfilename
	//print rwave
	//KillWaves/Z $bwave;KillWaves/Z $rwave;KillWaves/Z $owave;KillWaves/Z $qwave
	//Rename Detector,$rwave
	//Rename background,$bwave;Rename offsets,$owave;
	///make $qwave=root:'Startup:qforLS230
	
	//Note $rwave TheNote

	//display $rwave vs $qwave
	ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
	ShowInfo
end

macro openUSANS()

	silent 1
	variable refno=2,time1
	String Title
	String/g qwave,rwave, swave,mwave
	Open/D/R/M="Which USANS File is to be Opened?" refno
		//****/D stores full file name with path in s_filename and doesn't open the file
	print "sfilename= ",s_filename
	
//following is from function getfilename
 getfilename(s_filename)

	String LineOfNote,TheNote=gfilename
	Open /R refNo as s_filename
	variable Counter=0
	do
		FReadLine refNo, LineOfNote
		TheNote+=LineOfNote
			if (counter==3)
				Title=LineOfNote
			endif
		Counter+=1
	while(Counter<17)
	
	LoadWave/J/D/O/N/K=0/V={"\t, "," $",0,1}/L={0,17,0,2,4} s_filename
	qwave ="q"+gfilename 
	rwave ="r"+gfilename 
	swave= "s"+gfilename
	mwave="m"+gfilename
	KillWaves/Z $qwave
	KillWaves/Z $rwave
	KillWaves/Z $swave
	KillWaves/Z $mwave
	wave0/=10
	time1=wave2[1]
	wave2=sqrt(wave1)
	wave1/=time1
	wave2/=time1
	wave3/=time1
	Rename wave0,$qwave;
	Rename wave1,$rwave;
	Rename wave2,$swave;
	Rename wave3,$mwave
	Note $rwave TheNote  //makes header the wave note.

	display $rwave vs $qwave
	ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
	ErrorBars $rwave Y,wave=($swave,$swave)
	ShowInfo
	Textbox/N=text0/A=MC Title
	openusans()//recycles to open another wave
end

macro openTomBH()

	silent 1
	variable refno=2,time1
	String Title
	String/g qwave,rwave, swave
	Open/D/R/M="Which BH File is to be Opened?" refno
		//****/D stores full file name with path in s_filename and doesn't open the file
	print "sfilename= ",s_filename
	
//following is from function getfilename
 getfilename(s_filename)

	String LineOfNote,TheNote=gfilename
	Open /R refNo as s_filename
	variable Counter=0
	do
		FReadLine refNo, LineOfNote
		TheNote+=LineOfNote
			if (counter==3)
				Title=LineOfNote
			endif
		Counter+=1
	while(Counter<1)
	
	LoadWave/G/D/O/K=0/V={"\t, "," $",0,1}/L={0,2,0,0,4} s_filename
	qwave ="q"+gfilename;rwave ="r"+gfilename ;swave= "s"+gfilename
	KillWaves/Z $qwave;KillWaves/Z $rwave;KillWaves/Z $swave
	Rename wave1,$qwave;Rename wave2,$rwave;Rename wave3,$swave
	Note $rwave TheNote  //makes header the wave note.

	display $rwave vs $qwave
	ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
	ErrorBars $rwave Y,wave=($swave,$swave)
	ShowInfo
	Showtools
end
